<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Carbon\CarbonInterface;

$processHoursFunction = static function (CarbonInterface $date, string $format) {
    return $format.'ÃÂ¾'.($date->hour === 11 ? 'ÃÂ±' : '').'] LT';
};

/*
 * Authors:
 * - Kunal Marwaha
 * - Josh Soref
 * - FranÃƒÂ§ois B
 * - Tim Fish
 * - Serhan ApaydÃ„Â±n
 * - Max Mykhailenko
 * - JD Isaacks
 * - Max Kovpak
 * - AucT
 * - Philippe Vaucher
 * - Ilya Shaplyko
 * - Vadym Ievsieiev
 * - Denys Kurets
 * - Igor Kasyanchuk
 * - Tsutomu Kuroda
 * - tjku
 * - Max Melentiev
 * - Oleh
 * - epaminond
 * - Juanito Fatas
 * - Vitalii Khustochka
 * - Akira Matsuda
 * - Christopher Dell
 * - Enrique Vidal
 * - Simone Carletti
 * - Aaron Patterson
 * - Andriy Tyurnikov
 * - NicolÃƒÂ¡s Hock Isaza
 * - Iwakura Taro
 * - Andrii Ponomarov
 * - alecrabbit
 * - vystepanenko
 * - AlexWalkerson
 * - Andre Havryliuk (Andrend)
 * - Max Datsenko (datsenko-md)
 */
return [
    'year' => ':count Ã‘â‚¬Ã‘â€“ÃÂº|:count Ã‘â‚¬ÃÂ¾ÃÂºÃÂ¸|:count Ã‘â‚¬ÃÂ¾ÃÂºÃ‘â€“ÃÂ²',
    'y' => ':countÃ‘â‚¬|:countÃ‘â‚¬Ã‘â‚¬|:countÃ‘â‚¬Ã‘â‚¬',
    'a_year' => '{1}Ã‘â‚¬Ã‘â€“ÃÂº|:count Ã‘â‚¬Ã‘â€“ÃÂº|:count Ã‘â‚¬ÃÂ¾ÃÂºÃÂ¸|:count Ã‘â‚¬ÃÂ¾ÃÂºÃ‘â€“ÃÂ²',
    'month' => ':count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘Å’|:count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“|:count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“ÃÂ²',
    'm' => ':countÃÂ¼',
    'a_month' => '{1}ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘Å’|:count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘Å’|:count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“|:count ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“ÃÂ²',
    'week' => ':count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ½Ã‘â€“|:count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²',
    'w' => ':countÃ‘â€š',
    'a_week' => '{1}Ã‘â€šÃÂ¸ÃÂ¶ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ½Ã‘â€“|:count Ã‘â€šÃÂ¸ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²',
    'day' => ':count ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂ½Ã‘â€“|:count ÃÂ´ÃÂ½Ã‘â€“ÃÂ²',
    'd' => ':countÃÂ´',
    'a_day' => '{1}ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂ½Ã‘â€“|:count ÃÂ´ÃÂ½Ã‘â€“ÃÂ²',
    'hour' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'h' => ':countÃÂ³',
    'a_hour' => '{1}ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'minute' => ':count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'min' => ':countÃ‘â€¦ÃÂ²',
    'a_minute' => '{1}Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'second' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ°|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's' => ':countÃ‘ÂÃÂµÃÂº',
    'a_second' => '{1}ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ°|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_ago' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'a_hour_ago' => '{1}ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'minute_ago' => ':count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'a_minute_ago' => '{1}Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'second_ago' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_ago' => '{1}ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_from_now' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'a_hour_from_now' => '{1}ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'minute_from_now' => ':count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'a_minute_from_now' => '{1}Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'second_from_now' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_from_now' => '{1}ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_after' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'a_hour_after' => '{1}ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'minute_after' => ':count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'a_minute_after' => '{1}Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'second_after' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_after' => '{1}ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_before' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'a_hour_before' => '{1}ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½',
    'minute_before' => ':count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'a_minute_before' => '{1}Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸|:count Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½',
    'second_before' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_before' => '{1}ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'ago' => ':time Ã‘â€šÃÂ¾ÃÂ¼Ã‘Æ’',
    'from_now' => 'ÃÂ·ÃÂ° :time',
    'after' => ':time ÃÂ¿Ã‘â€“Ã‘ÂÃÂ»Ã‘Â',
    'before' => ':time ÃÂ´ÃÂ¾',
    'diff_now' => 'Ã‘â€°ÃÂ¾ÃÂ¹ÃÂ½ÃÂ¾',
    'diff_today' => 'ÃÂ¡Ã‘Å’ÃÂ¾ÃÂ³ÃÂ¾ÃÂ´ÃÂ½Ã‘â€“',
    'diff_today_regexp' => 'ÃÂ¡Ã‘Å’ÃÂ¾ÃÂ³ÃÂ¾ÃÂ´ÃÂ½Ã‘â€“(?:\\s+ÃÂ¾)?',
    'diff_yesterday' => 'ÃÂ²Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°',
    'diff_yesterday_regexp' => 'Ãâ€™Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°(?:\\s+ÃÂ¾)?',
    'diff_tomorrow' => 'ÃÂ·ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ°',
    'diff_tomorrow_regexp' => 'Ãâ€”ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ°(?:\\s+ÃÂ¾)?',
    'diff_before_yesterday' => 'ÃÂ¿ÃÂ¾ÃÂ·ÃÂ°ÃÂ²Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°',
    'diff_after_tomorrow' => 'ÃÂ¿Ã‘â€“Ã‘ÂÃÂ»Ã‘ÂÃÂ·ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ°',
    'period_recurrences' => 'ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ Ã‘â‚¬ÃÂ°ÃÂ·|:count Ã‘â‚¬ÃÂ°ÃÂ·ÃÂ¸|:count Ã‘â‚¬ÃÂ°ÃÂ·Ã‘â€“ÃÂ²',
    'period_interval' => 'ÃÂºÃÂ¾ÃÂ¶ÃÂ½Ã‘â€“ :interval',
    'period_start_date' => 'ÃÂ· :date',
    'period_end_date' => 'ÃÂ´ÃÂ¾ :date',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY, HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY, HH:mm',
    ],
    'calendar' => [
        'sameDay' => static fn (CarbonInterface $date) => $processHoursFunction($date, '[ÃÂ¡Ã‘Å’ÃÂ¾ÃÂ³ÃÂ¾ÃÂ´ÃÂ½Ã‘â€“ '),
        'nextDay' => static fn (CarbonInterface $date) => $processHoursFunction($date, '[Ãâ€”ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ° '),
        'nextWeek' => static fn (CarbonInterface $date) => $processHoursFunction($date, '[ÃÂ£] dddd ['),
        'lastDay' => static fn (CarbonInterface $date) => $processHoursFunction($date, '[Ãâ€™Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ° '),
        'lastWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0, 3, 5, 6 => $processHoursFunction($date, '[ÃÅ“ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾Ã‘â€”] dddd ['),
            default => $processHoursFunction($date, '[ÃÅ“ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾ÃÂ³ÃÂ¾] dddd ['),
        },
        'sameElse' => 'L',
    ],
    'ordinal' => static fn ($number, $period) => match ($period) {
        'M', 'd', 'DDD', 'w', 'W' => $number.'-ÃÂ¹',
        'D' => $number.'-ÃÂ³ÃÂ¾',
        default => $number,
    },
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€“';
        }

        if ($hour < 12) {
            return 'Ã‘â‚¬ÃÂ°ÃÂ½ÃÂºÃ‘Æ’';
        }

        if ($hour < 17) {
            return 'ÃÂ´ÃÂ½Ã‘Â';
        }

        return 'ÃÂ²ÃÂµÃ‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°';
    },
    'months' => ['Ã‘ÂÃ‘â€“Ã‘â€¡ÃÂ½Ã‘Â', 'ÃÂ»Ã‘Å½Ã‘â€šÃÂ¾ÃÂ³ÃÂ¾', 'ÃÂ±ÃÂµÃ‘â‚¬ÃÂµÃÂ·ÃÂ½Ã‘Â', 'ÃÂºÃÂ²Ã‘â€“Ã‘â€šÃÂ½Ã‘Â', 'Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂ½Ã‘Â', 'Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ²ÃÂ½Ã‘Â', 'ÃÂ»ÃÂ¸ÃÂ¿ÃÂ½Ã‘Â', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂ¿ÃÂ½Ã‘Â', 'ÃÂ²ÃÂµÃ‘â‚¬ÃÂµÃ‘ÂÃÂ½Ã‘Â', 'ÃÂ¶ÃÂ¾ÃÂ²Ã‘â€šÃÂ½Ã‘Â', 'ÃÂ»ÃÂ¸Ã‘ÂÃ‘â€šÃÂ¾ÃÂ¿ÃÂ°ÃÂ´ÃÂ°', 'ÃÂ³Ã‘â‚¬Ã‘Æ’ÃÂ´ÃÂ½Ã‘Â'],
    'months_standalone' => ['Ã‘ÂÃ‘â€“Ã‘â€¡ÃÂµÃÂ½Ã‘Å’', 'ÃÂ»Ã‘Å½Ã‘â€šÃÂ¸ÃÂ¹', 'ÃÂ±ÃÂµÃ‘â‚¬ÃÂµÃÂ·ÃÂµÃÂ½Ã‘Å’', 'ÃÂºÃÂ²Ã‘â€“Ã‘â€šÃÂµÃÂ½Ã‘Å’', 'Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂµÃÂ½Ã‘Å’', 'Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Å’', 'ÃÂ»ÃÂ¸ÃÂ¿ÃÂµÃÂ½Ã‘Å’', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂ¿ÃÂµÃÂ½Ã‘Å’', 'ÃÂ²ÃÂµÃ‘â‚¬ÃÂµÃ‘ÂÃÂµÃÂ½Ã‘Å’', 'ÃÂ¶ÃÂ¾ÃÂ²Ã‘â€šÃÂµÃÂ½Ã‘Å’', 'ÃÂ»ÃÂ¸Ã‘ÂÃ‘â€šÃÂ¾ÃÂ¿ÃÂ°ÃÂ´', 'ÃÂ³Ã‘â‚¬Ã‘Æ’ÃÂ´ÃÂµÃÂ½Ã‘Å’'],
    'months_short' => ['Ã‘ÂÃ‘â€“Ã‘â€¡', 'ÃÂ»Ã‘Å½Ã‘â€š', 'ÃÂ±ÃÂµÃ‘â‚¬', 'ÃÂºÃÂ²Ã‘â€“', 'Ã‘â€šÃ‘â‚¬ÃÂ°', 'Ã‘â€¡ÃÂµÃ‘â‚¬', 'ÃÂ»ÃÂ¸ÃÂ¿', 'Ã‘ÂÃÂµÃ‘â‚¬', 'ÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂ¶ÃÂ¾ÃÂ²', 'ÃÂ»ÃÂ¸Ã‘Â', 'ÃÂ³Ã‘â‚¬Ã‘Æ’'],
    'months_regexp' => '/(D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => static function (CarbonInterface $date, $format, $index) {
        static $words = [
            'nominative' => ['ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘Â', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂ¾ÃÂº', 'ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ¾ÃÂº', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´ÃÂ°', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘Â', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°'],
            'accusative' => ['ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘Å½', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂ¾ÃÂº', 'ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ¾ÃÂº', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´Ã‘Æ’', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘Å½', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’'],
            'genitive' => ['ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘â€“', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂºÃÂ°', 'ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂºÃÂ°', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´ÃÂ¸', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬ÃÂ³ÃÂ°', 'ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘â€“', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ¸'],
        ];

        $format ??= '';
        $nounCase = preg_match('/(\[(Ãâ€™|ÃÂ²|ÃÂ£|Ã‘Æ’)\])\s+dddd/u', $format)
            ? 'accusative'
            : (
                preg_match('/\[?(?:ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾Ã‘â€”|ÃÂ½ÃÂ°Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ¿ÃÂ½ÃÂ¾Ã‘â€”)?\s*\]\s+dddd/u', $format)
                    ? 'genitive'
                    : 'nominative'
            );

        return $words[$nounCase][$index] ?? null;
    },
    'weekdays_short' => ['ÃÂ½ÃÂ´', 'ÃÂ¿ÃÂ½', 'ÃÂ²Ã‘â€š', 'Ã‘ÂÃ‘â‚¬', 'Ã‘â€¡Ã‘â€š', 'ÃÂ¿Ã‘â€š', 'Ã‘ÂÃÂ±'],
    'weekdays_min' => ['ÃÂ½ÃÂ´', 'ÃÂ¿ÃÂ½', 'ÃÂ²Ã‘â€š', 'Ã‘ÂÃ‘â‚¬', 'Ã‘â€¡Ã‘â€š', 'ÃÂ¿Ã‘â€š', 'Ã‘ÂÃÂ±'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' i '],
];
