<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Josh Soref
 * - Alan Agius
 * - Erhan Gundogan
 * - FranÃƒÂ§ois B
 * - JD Isaacks
 * - Murat YÃƒÂ¼ksel
 * - Baran Ã…Å¾engÃƒÂ¼l
 * - Selami (selamialtin)
 * - TeomanBey
 */
return [
    'year' => ':count yÃ„Â±l',
    'a_year' => '{1}bir yÃ„Â±l|[-Inf,Inf]:count yÃ„Â±l',
    'y' => ':county',
    'month' => ':count ay',
    'a_month' => '{1}bir ay|[-Inf,Inf]:count ay',
    'm' => ':countay',
    'week' => ':count hafta',
    'a_week' => '{1}bir hafta|[-Inf,Inf]:count hafta',
    'w' => ':counth',
    'day' => ':count gÃƒÂ¼n',
    'a_day' => '{1}bir gÃƒÂ¼n|[-Inf,Inf]:count gÃƒÂ¼n',
    'd' => ':countg',
    'hour' => ':count saat',
    'a_hour' => '{1}bir saat|[-Inf,Inf]:count saat',
    'h' => ':countsa',
    'minute' => ':count dakika',
    'a_minute' => '{1}bir dakika|[-Inf,Inf]:count dakika',
    'min' => ':countdk',
    'second' => ':count saniye',
    'a_second' => '{1}birkaÃƒÂ§ saniye|[-Inf,Inf]:count saniye',
    's' => ':countsn',
    'ago' => ':time ÃƒÂ¶nce',
    'from_now' => ':time sonra',
    'after' => ':time sonra',
    'before' => ':time ÃƒÂ¶nce',
    'diff_now' => 'Ã…Å¸imdi',
    'diff_today' => 'bugÃƒÂ¼n',
    'diff_today_regexp' => 'bugÃƒÂ¼n(?:\\s+saat)?',
    'diff_yesterday' => 'dÃƒÂ¼n',
    'diff_tomorrow' => 'yarÃ„Â±n',
    'diff_tomorrow_regexp' => 'yarÃ„Â±n(?:\\s+saat)?',
    'diff_before_yesterday' => 'evvelsi gÃƒÂ¼n',
    'diff_after_tomorrow' => 'ÃƒÂ¶bÃƒÂ¼r gÃƒÂ¼n',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[bugÃƒÂ¼n saat] LT',
        'nextDay' => '[yarÃ„Â±n saat] LT',
        'nextWeek' => '[gelecek] dddd [saat] LT',
        'lastDay' => '[dÃƒÂ¼n] LT',
        'lastWeek' => '[geÃƒÂ§en] dddd [saat] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number, $period) {
        switch ($period) {
            case 'd':
            case 'D':
            case 'Do':
            case 'DD':
                return $number;
            default:
                if ($number === 0) {  // special case for zero
                    return "$number'Ã„Â±ncÃ„Â±";
                }

                static $suffixes = [
                    1 => '\'inci',
                    5 => '\'inci',
                    8 => '\'inci',
                    70 => '\'inci',
                    80 => '\'inci',
                    2 => '\'nci',
                    7 => '\'nci',
                    20 => '\'nci',
                    50 => '\'nci',
                    3 => '\'ÃƒÂ¼ncÃƒÂ¼',
                    4 => '\'ÃƒÂ¼ncÃƒÂ¼',
                    100 => '\'ÃƒÂ¼ncÃƒÂ¼',
                    6 => '\'ncÃ„Â±',
                    9 => '\'uncu',
                    10 => '\'uncu',
                    30 => '\'uncu',
                    60 => '\'Ã„Â±ncÃ„Â±',
                    90 => '\'Ã„Â±ncÃ„Â±',
                ];

                $lastDigit = $number % 10;

                return $number.($suffixes[$lastDigit] ?? $suffixes[$number % 100 - $lastDigit] ?? $suffixes[$number >= 100 ? 100 : -1] ?? '');
        }
    },
    'meridiem' => ['Ãƒâ€“Ãƒâ€“', 'Ãƒâ€“S', 'ÃƒÂ¶ÃƒÂ¶', 'ÃƒÂ¶s'],
    'months' => ['Ocak', 'Ã…Å¾ubat', 'Mart', 'Nisan', 'MayÃ„Â±s', 'Haziran', 'Temmuz', 'AÃ„Å¸ustos', 'EylÃƒÂ¼l', 'Ekim', 'KasÃ„Â±m', 'AralÃ„Â±k'],
    'months_short' => ['Oca', 'Ã…Å¾ub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'AÃ„Å¸u', 'Eyl', 'Eki', 'Kas', 'Ara'],
    'weekdays' => ['Pazar', 'Pazartesi', 'SalÃ„Â±', 'Ãƒâ€¡arÃ…Å¸amba', 'PerÃ…Å¸embe', 'Cuma', 'Cumartesi'],
    'weekdays_short' => ['Paz', 'Pts', 'Sal', 'Ãƒâ€¡ar', 'Per', 'Cum', 'Cts'],
    'weekdays_min' => ['Pz', 'Pt', 'Sa', 'Ãƒâ€¡a', 'Pe', 'Cu', 'Ct'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' ve '],
];
