<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Symfony\Component\Translation\PluralizationRules;

// @codeCoverageIgnoreStart
if (class_exists(PluralizationRules::class)) {
    PluralizationRules::set(static function ($number) {
        return PluralizationRules::get($number, 'sr');
    }, 'sr_Cyrl_XK');
}
// @codeCoverageIgnoreEnd

return array_replace_recursive(require __DIR__.'/sr_Cyrl_BA.php', [
    'weekdays' => ['ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°ÃÂº', 'Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº', 'Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂ°', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂ°ÃÂº', 'ÃÂ¿ÃÂµÃ‘â€šÃÂ°ÃÂº', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°'],
]);
