<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Symfony\Component\Translation\PluralizationRules;

// @codeCoverageIgnoreStart
if (class_exists(PluralizationRules::class)) {
    PluralizationRules::set(static function ($number) {
        return PluralizationRules::get($number, 'sr');
    }, 'sr_Cyrl_BA');
}
// @codeCoverageIgnoreEnd

return array_replace_recursive(require __DIR__.'/sr_Cyrl.php', [
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'D.M.yy.',
        'LL' => 'DD.MM.YYYY.',
        'LLL' => 'DD. MMMM YYYY. HH:mm',
        'LLLL' => 'dddd, DD. MMMM YYYY. HH:mm',
    ],
    'weekdays' => ['ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂ°', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°ÃÂº', 'Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº', 'Ã‘ÂÃ‘â‚¬ÃÂ¸Ã‘ËœÃÂµÃÂ´ÃÂ°', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂ°ÃÂº', 'ÃÂ¿ÃÂµÃ‘â€šÃÂ°ÃÂº', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°'],
    'weekdays_short' => ['ÃÂ½ÃÂµÃÂ´.', 'ÃÂ¿ÃÂ¾ÃÂ½.', 'Ã‘Æ’Ã‘â€š.', 'Ã‘ÂÃ‘â‚¬.', 'Ã‘â€¡ÃÂµÃ‘â€š.', 'ÃÂ¿ÃÂµÃ‘â€š.', 'Ã‘ÂÃ‘Æ’ÃÂ±.'],
]);
