<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Cassiano Montanari
 * - Matt Pope
 * - FranÃƒÂ§ois B
 * - Prodis
 * - JD Isaacks
 * - Raphael Amorim
 * - JoÃƒÂ£o MagalhÃƒÂ£es
 * - victortobias
 * - Paulo Freitas
 * - Sebastian Thierer
 * - Claudson Martins (claudsonm)
 */

use Carbon\CarbonInterface;

return [
    'year' => ':count ano|:count anos',
    'a_year' => 'um ano|:count anos',
    'y' => ':counta',
    'month' => ':count mÃƒÂªs|:count meses',
    'a_month' => 'um mÃƒÂªs|:count meses',
    'm' => ':countm',
    'week' => ':count semana|:count semanas',
    'a_week' => 'uma semana|:count semanas',
    'w' => ':countsem',
    'day' => ':count dia|:count dias',
    'a_day' => 'um dia|:count dias',
    'd' => ':countd',
    'hour' => ':count hora|:count horas',
    'a_hour' => 'uma hora|:count horas',
    'h' => ':counth',
    'minute' => ':count minuto|:count minutos',
    'a_minute' => 'um minuto|:count minutos',
    'min' => ':countmin',
    'second' => ':count segundo|:count segundos',
    'a_second' => 'alguns segundos|:count segundos',
    's' => ':counts',
    'millisecond' => ':count milissegundo|:count milissegundos',
    'a_millisecond' => 'um milissegundo|:count milissegundos',
    'ms' => ':countms',
    'microsecond' => ':count microssegundo|:count microssegundos',
    'a_microsecond' => 'um microssegundo|:count microssegundos',
    'Ã‚Âµs' => ':countÃ‚Âµs',
    'ago' => 'hÃƒÂ¡ :time',
    'from_now' => 'em :time',
    'after' => ':time depois',
    'before' => ':time antes',
    'diff_now' => 'agora',
    'diff_today' => 'Hoje',
    'diff_today_regexp' => 'Hoje(?:\\s+ÃƒÂ s)?',
    'diff_yesterday' => 'ontem',
    'diff_yesterday_regexp' => 'Ontem(?:\\s+ÃƒÂ s)?',
    'diff_tomorrow' => 'amanhÃƒÂ£',
    'diff_tomorrow_regexp' => 'AmanhÃƒÂ£(?:\\s+ÃƒÂ s)?',
    'diff_before_yesterday' => 'anteontem',
    'diff_after_tomorrow' => 'depois de amanhÃƒÂ£',
    'period_recurrences' => 'uma vez|:count vezes',
    'period_interval' => 'cada :interval',
    'period_start_date' => 'de :date',
    'period_end_date' => 'atÃƒÂ© :date',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D [de] MMMM [de] YYYY',
        'LLL' => 'D [de] MMMM [de] YYYY HH:mm',
        'LLLL' => 'dddd, D [de] MMMM [de] YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Hoje ÃƒÂ s] LT',
        'nextDay' => '[AmanhÃƒÂ£ ÃƒÂ s] LT',
        'nextWeek' => 'dddd [ÃƒÂ s] LT',
        'lastDay' => '[Ontem ÃƒÂ s] LT',
        'lastWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0, 6 => '[ÃƒÅ¡ltimo] dddd [ÃƒÂ s] LT',
            default => '[ÃƒÅ¡ltima] dddd [ÃƒÂ s] LT',
        },
        'sameElse' => 'L',
    ],
    'ordinal' => ':numberÃ‚Âº',
    'months' => ['janeiro', 'fevereiro', 'marÃƒÂ§o', 'abril', 'maio', 'junho', 'julho', 'agosto', 'setembro', 'outubro', 'novembro', 'dezembro'],
    'months_short' => ['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'],
    'weekdays' => ['domingo', 'segunda-feira', 'terÃƒÂ§a-feira', 'quarta-feira', 'quinta-feira', 'sexta-feira', 'sÃƒÂ¡bado'],
    'weekdays_short' => ['dom', 'seg', 'ter', 'qua', 'qui', 'sex', 'sÃƒÂ¡b'],
    'weekdays_min' => ['Do', '2Ã‚Âª', '3Ã‚Âª', '4Ã‚Âª', '5Ã‚Âª', '6Ã‚Âª', 'SÃƒÂ¡'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' e '],
    'ordinal_words' => [
        'of' => 'de',
        'first' => 'primeira',
        'second' => 'segunda',
        'third' => 'terceira',
        'fourth' => 'quarta',
        'fifth' => 'quinta',
        'last' => 'ÃƒÂºltima',
    ],
];
