<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - WacÃ…â€šaw Jacek
 * - FranÃƒÂ§ois B
 * - Tim Fish
 * - Serhan ApaydÃ„Â±n
 * - Massimiliano Caniparoli
 * - JD Isaacks
 * - Jakub Szwacz
 * - Jan
 * - Paul
 * - damlys
 * - Marek (marast78)
 * - Peter (UnrulyNatives)
 * - Qrzysio
 * - Jan (aso824)
 * - diverpl
 */

use Carbon\CarbonInterface;

return [
    'year' => ':count rok|:count lata|:count lat',
    'a_year' => 'rok|:count lata|:count lat',
    'y' => ':count r|:count l|:count l',
    'month' => ':count miesiÃ„â€¦c|:count miesiÃ„â€¦ce|:count miesiÃ„â„¢cy',
    'a_month' => 'miesiÃ„â€¦c|:count miesiÃ„â€¦ce|:count miesiÃ„â„¢cy',
    'm' => ':count mies.',
    'week' => ':count tydzieÃ…â€ž|:count tygodnie|:count tygodni',
    'a_week' => 'tydzieÃ…â€ž|:count tygodnie|:count tygodni',
    'w' => ':count tyg.',
    'day' => ':count dzieÃ…â€ž|:count dni|:count dni',
    'a_day' => 'dzieÃ…â€ž|:count dni|:count dni',
    'd' => ':count d',
    'hour' => ':count godzina|:count godziny|:count godzin',
    'a_hour' => 'godzina|:count godziny|:count godzin',
    'h' => ':count godz.',
    'minute' => ':count minuta|:count minuty|:count minut',
    'a_minute' => 'minuta|:count minuty|:count minut',
    'min' => ':count min',
    'second' => ':count sekunda|:count sekundy|:count sekund',
    'a_second' => '{1}kilka sekund|:count sekunda|:count sekundy|:count sekund',
    's' => ':count sek.',
    'ago' => ':time temu',
    'from_now' => static function ($time) {
        return 'za '.strtr($time, [
            'godzina' => 'godzinÃ„â„¢',
            'minuta' => 'minutÃ„â„¢',
            'sekunda' => 'sekundÃ„â„¢',
        ]);
    },
    'after' => ':time po',
    'before' => ':time przed',
    'diff_now' => 'teraz',
    'diff_today' => 'DziÃ…â€º',
    'diff_today_regexp' => 'DziÃ…â€º(?:\\s+o)?',
    'diff_yesterday' => 'wczoraj',
    'diff_yesterday_regexp' => 'Wczoraj(?:\\s+o)?',
    'diff_tomorrow' => 'jutro',
    'diff_tomorrow_regexp' => 'Jutro(?:\\s+o)?',
    'diff_before_yesterday' => 'przedwczoraj',
    'diff_after_tomorrow' => 'pojutrze',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[DziÃ…â€º o] LT',
        'nextDay' => '[Jutro o] LT',
        'nextWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0 => '[W niedzielÃ„â„¢ o] LT',
            2 => '[We wtorek o] LT',
            3 => '[W Ã…â€ºrodÃ„â„¢ o] LT',
            6 => '[W sobotÃ„â„¢ o] LT',
            default => '[W] dddd [o] LT',
        },
        'lastDay' => '[Wczoraj o] LT',
        'lastWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0 => '[W zeszÃ…â€šÃ„â€¦ niedzielÃ„â„¢ o] LT',
            3 => '[W zeszÃ…â€šÃ„â€¦ Ã…â€ºrodÃ„â„¢ o] LT',
            6 => '[W zeszÃ…â€šÃ„â€¦ sobotÃ„â„¢ o] LT',
            default => '[W zeszÃ…â€šy] dddd [o] LT',
        },
        'sameElse' => 'L',
    ],
    'ordinal' => ':number.',
    'months' => ['stycznia', 'lutego', 'marca', 'kwietnia', 'maja', 'czerwca', 'lipca', 'sierpnia', 'wrzeÃ…â€ºnia', 'paÃ…Âºdziernika', 'listopada', 'grudnia'],
    'months_standalone' => ['styczeÃ…â€ž', 'luty', 'marzec', 'kwiecieÃ…â€ž', 'maj', 'czerwiec', 'lipiec', 'sierpieÃ…â€ž', 'wrzesieÃ…â€ž', 'paÃ…Âºdziernik', 'listopad', 'grudzieÃ…â€ž'],
    'months_short' => ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz', 'paÃ…Âº', 'lis', 'gru'],
    'months_regexp' => '/(DD?o?\.?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['niedziela', 'poniedziaÃ…â€šek', 'wtorek', 'Ã…â€ºroda', 'czwartek', 'piÃ„â€¦tek', 'sobota'],
    'weekdays_short' => ['ndz', 'pon', 'wt', 'Ã…â€ºr', 'czw', 'pt', 'sob'],
    'weekdays_min' => ['Nd', 'Pn', 'Wt', 'Ã…Å¡r', 'Cz', 'Pt', 'So'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' i '],
    'meridiem' => ['przed poÃ…â€šudniem', 'po poÃ…â€šudniu'],
];
