<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Carbon\CarbonInterface;

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Philippe Vaucher
 * - pirminis
 * - Tsutomu Kuroda
 * - tjku
 * - Andris ZÃ„ÂÃ„Â£eris
 * - Max Melentiev
 * - Edgars Beigarts
 * - Juanito Fatas
 * - Vitauts StoÃ„Âka
 * - Akira Matsuda
 * - Christopher Dell
 * - Enrique Vidal
 * - Simone Carletti
 * - Aaron Patterson
 * - Kaspars Bankovskis
 * - NicolÃƒÂ¡s Hock Isaza
 * - Viesturs Kavacs (Kavacky)
 * - zakse
 * - Janis Eglitis (janiseglitis)
 * - Guntars
 * - Juris Sudmalis
 */
$daysOfWeek = ['svÃ„â€œtdiena', 'pirmdiena', 'otrdiena', 'treÃ…Â¡diena', 'ceturtdiena', 'piektdiena', 'sestdiena'];
$daysOfWeekLocativum = ['svÃ„â€œtdien', 'pirmdien', 'otrdien', 'treÃ…Â¡dien', 'ceturtdien', 'piektdien', 'sestdien'];

$transformDiff = static fn (string $input) => strtr($input, [
    // Nominative => "pirms/pÃ„â€œc" Dative
    'gads' => 'gada',
    'gadi' => 'gadiem',
    'gadu' => 'gadiem',
    'mÃ„â€œnesis' => 'mÃ„â€œneÃ…Â¡a',
    'mÃ„â€œneÃ…Â¡i' => 'mÃ„â€œneÃ…Â¡iem',
    'mÃ„â€œneÃ…Â¡u' => 'mÃ„â€œneÃ…Â¡iem',
    'nedÃ„â€œÃ„Â¼a' => 'nedÃ„â€œÃ„Â¼as',
    'nedÃ„â€œÃ„Â¼as' => 'nedÃ„â€œÃ„Â¼Ã„Âm',
    'nedÃ„â€œÃ„Â¼u' => 'nedÃ„â€œÃ„Â¼Ã„Âm',
    'diena' => 'dienas',
    'dienas' => 'dienÃ„Âm',
    'dienu' => 'dienÃ„Âm',
    'stunda' => 'stundas',
    'stundas' => 'stundÃ„Âm',
    'stundu' => 'stundÃ„Âm',
    'minÃ…Â«te' => 'minÃ…Â«tes',
    'minÃ…Â«tes' => 'minÃ…Â«tÃ„â€œm',
    'minÃ…Â«Ã…Â¡u' => 'minÃ…Â«tÃ„â€œm',
    'sekunde' => 'sekundes',
    'sekundes' => 'sekundÃ„â€œm',
    'sekunÃ…Â¾u' => 'sekundÃ„â€œm',
]);

return [
    'ago' => static fn (string $time) => 'pirms '.$transformDiff($time),
    'from_now' => static fn (string $time) => 'pÃ„â€œc '.$transformDiff($time),

    'year' => '0 gadu|:count gads|:count gadi',
    'y' => ':count g.',
    'a_year' => '{1}gads|0 gadu|:count gads|:count gadi',
    'month' => '0 mÃ„â€œneÃ…Â¡u|:count mÃ„â€œnesis|:count mÃ„â€œneÃ…Â¡i',
    'm' => ':count mÃ„â€œn.',
    'a_month' => '{1}mÃ„â€œnesis|0 mÃ„â€œneÃ…Â¡u|:count mÃ„â€œnesis|:count mÃ„â€œneÃ…Â¡i',
    'week' => '0 nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼a|:count nedÃ„â€œÃ„Â¼as',
    'w' => ':count ned.',
    'a_week' => '{1}nedÃ„â€œÃ„Â¼a|0 nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼a|:count nedÃ„â€œÃ„Â¼as',
    'day' => '0 dienu|:count diena|:count dienas',
    'd' => ':count d.',
    'a_day' => '{1}diena|0 dienu|:count diena|:count dienas',
    'hour' => '0 stundu|:count stunda|:count stundas',
    'h' => ':count st.',
    'a_hour' => '{1}stunda|0 stundu|:count stunda|:count stundas',
    'minute' => '0 minÃ…Â«Ã…Â¡u|:count minÃ…Â«te|:count minÃ…Â«tes',
    'min' => ':count min.',
    'a_minute' => '{1}minÃ…Â«te|0 minÃ…Â«Ã…Â¡u|:count minÃ…Â«te|:count minÃ…Â«tes',
    'second' => '0 sekunÃ…Â¾u|:count sekunde|:count sekundes',
    's' => ':count sek.',
    'a_second' => '{1}sekunde|0 sekunÃ…Â¾u|:count sekunde|:count sekundes',

    'after' => ':time vÃ„â€œlÃ„Âk',
    'year_after' => '0 gadus|:count gadu|:count gadus',
    'a_year_after' => '{1}gadu|0 gadus|:count gadu|:count gadus',
    'month_after' => '0 mÃ„â€œneÃ…Â¡us|:count mÃ„â€œnesi|:count mÃ„â€œneÃ…Â¡us',
    'a_month_after' => '{1}mÃ„â€œnesi|0 mÃ„â€œneÃ…Â¡us|:count mÃ„â€œnesi|:count mÃ„â€œneÃ…Â¡us',
    'week_after' => '0 nedÃ„â€œÃ„Â¼as|:count nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼as',
    'a_week_after' => '{1}nedÃ„â€œÃ„Â¼u|0 nedÃ„â€œÃ„Â¼as|:count nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼as',
    'day_after' => '0 dienas|:count dienu|:count dienas',
    'a_day_after' => '{1}dienu|0 dienas|:count dienu|:count dienas',
    'hour_after' => '0 stundas|:count stundu|:count stundas',
    'a_hour_after' => '{1}stundu|0 stundas|:count stundu|:count stundas',
    'minute_after' => '0 minÃ…Â«tes|:count minÃ…Â«ti|:count minÃ…Â«tes',
    'a_minute_after' => '{1}minÃ…Â«ti|0 minÃ…Â«tes|:count minÃ…Â«ti|:count minÃ…Â«tes',
    'second_after' => '0 sekundes|:count sekundi|:count sekundes',
    'a_second_after' => '{1}sekundi|0 sekundes|:count sekundi|:count sekundes',

    'before' => ':time agrÃ„Âk',
    'year_before' => '0 gadus|:count gadu|:count gadus',
    'a_year_before' => '{1}gadu|0 gadus|:count gadu|:count gadus',
    'month_before' => '0 mÃ„â€œneÃ…Â¡us|:count mÃ„â€œnesi|:count mÃ„â€œneÃ…Â¡us',
    'a_month_before' => '{1}mÃ„â€œnesi|0 mÃ„â€œneÃ…Â¡us|:count mÃ„â€œnesi|:count mÃ„â€œneÃ…Â¡us',
    'week_before' => '0 nedÃ„â€œÃ„Â¼as|:count nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼as',
    'a_week_before' => '{1}nedÃ„â€œÃ„Â¼u|0 nedÃ„â€œÃ„Â¼as|:count nedÃ„â€œÃ„Â¼u|:count nedÃ„â€œÃ„Â¼as',
    'day_before' => '0 dienas|:count dienu|:count dienas',
    'a_day_before' => '{1}dienu|0 dienas|:count dienu|:count dienas',
    'hour_before' => '0 stundas|:count stundu|:count stundas',
    'a_hour_before' => '{1}stundu|0 stundas|:count stundu|:count stundas',
    'minute_before' => '0 minÃ…Â«tes|:count minÃ…Â«ti|:count minÃ…Â«tes',
    'a_minute_before' => '{1}minÃ…Â«ti|0 minÃ…Â«tes|:count minÃ…Â«ti|:count minÃ…Â«tes',
    'second_before' => '0 sekundes|:count sekundi|:count sekundes',
    'a_second_before' => '{1}sekundi|0 sekundes|:count sekundi|:count sekundes',

    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' un '],

    'diff_now' => 'tagad',
    'diff_today' => 'Ã…Â¡odien',
    'diff_yesterday' => 'vakar',
    'diff_before_yesterday' => 'aizvakar',
    'diff_tomorrow' => 'rÃ„Â«t',
    'diff_after_tomorrow' => 'parÃ„Â«t',

    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY.',
        'LL' => 'YYYY. [gada] D. MMMM',
        'LLL' => 'DD.MM.YYYY., HH:mm',
        'LLLL' => 'YYYY. [gada] D. MMMM, HH:mm',
    ],

    'calendar' => [
        'sameDay' => '[Ã…Â¡odien] [plkst.] LT',
        'nextDay' => '[rÃ„Â«t] [plkst.] LT',
        'nextWeek' => static function (CarbonInterface $current, CarbonInterface $other) use ($daysOfWeekLocativum) {
            if ($current->week !== $other->week) {
                return '[nÃ„ÂkoÃ…Â¡o] ['.$daysOfWeekLocativum[$current->dayOfWeek].'] [plkst.] LT';
            }

            return '['.$daysOfWeekLocativum[$current->dayOfWeek].'] [plkst.] LT';
        },
        'lastDay' => '[vakar] [plkst.] LT',
        'lastWeek' => static function (CarbonInterface $current) use ($daysOfWeekLocativum) {
            return '[pagÃ„ÂjuÃ…Â¡o] ['.$daysOfWeekLocativum[$current->dayOfWeek].'] [plkst.] LT';
        },
        'sameElse' => 'L',
    ],

    'weekdays' => $daysOfWeek,
    'weekdays_short' => ['Sv.', 'P.', 'O.', 'T.', 'C.', 'Pk.', 'S.'],
    'weekdays_min' => ['Sv.', 'P.', 'O.', 'T.', 'C.', 'Pk.', 'S.'],
    'months' => ['janvÃ„Âris', 'februÃ„Âris', 'marts', 'aprÃ„Â«lis', 'maijs', 'jÃ…Â«nijs', 'jÃ…Â«lijs', 'augusts', 'septembris', 'oktobris', 'novembris', 'decembris'],
    'months_standalone' => ['janvÃ„ÂrÃ„Â«', 'februÃ„ÂrÃ„Â«', 'martÃ„Â', 'aprÃ„Â«lÃ„Â«', 'maijÃ„Â', 'jÃ…Â«nijÃ„Â', 'jÃ…Â«lijÃ„Â', 'augustÃ„Â', 'septembrÃ„Â«', 'oktobrÃ„Â«', 'novembrÃ„Â«', 'decembrÃ„Â«'],
    'months_short' => ['janv.', 'febr.', 'martÃ„Â', 'apr.', 'maijÃ„Â', 'jÃ…Â«n.', 'jÃ…Â«l.', 'aug.', 'sept.', 'okt.', 'nov.', 'dec.'],
    'meridiem' => ['priekÃ…Â¡pusdiena', 'pÃ„â€œcpusdiena'],
];
