<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Philippe Vaucher
 * - Tsutomu Kuroda
 * - tjku
 * - valdas406
 * - Justas Palumickas
 * - Max Melentiev
 * - Andrius Janauskas
 * - Juanito Fatas
 * - Akira Matsuda
 * - Christopher Dell
 * - Enrique Vidal
 * - Simone Carletti
 * - Aaron Patterson
 * - NicolÃƒÂ¡s Hock Isaza
 * - Laurynas Butkus
 * - Sven Fuchs
 * - Dominykas TijÃ…Â«naitis
 * - Justinas Bolys
 * - RiÃ„Âardas
 * - Kirill Chalkin
 * - Rolandas
 * - Justinas (Gamesh)
 * - Sam Axe
 */
return [
    'year' => ':count metai|:count metai|:count metÃ…Â³',
    'y' => ':count m.',
    'month' => ':count mÃ„â€”nuo|:count mÃ„â€”nesiai|:count mÃ„â€”nesÃ„Â¯',
    'm' => ':count mÃ„â€”n.',
    'week' => ':count savaitÃ„â€”|:count savaitÃ„â€”s|:count savaitÃ„â„¢',
    'w' => ':count sav.',
    'day' => ':count diena|:count dienos|:count dienÃ…Â³',
    'd' => ':count d.',
    'hour' => ':count valanda|:count valandos|:count valandÃ…Â³',
    'h' => ':count val.',
    'minute' => ':count minutÃ„â€”|:count minutÃ„â€”s|:count minutÃ„â„¢',
    'min' => ':count min.',
    'second' => ':count sekundÃ„â€”|:count sekundÃ„â€”s|:count sekundÃ…Â¾iÃ…Â³',
    's' => ':count sek.',

    'year_ago' => ':count metus|:count metus|:count metÃ…Â³',
    'month_ago' => ':count mÃ„â€”nesÃ„Â¯|:count mÃ„â€”nesius|:count mÃ„â€”nesiÃ…Â³',
    'week_ago' => ':count savaitÃ„â„¢|:count savaites|:count savaiÃ„ÂiÃ…Â³',
    'day_ago' => ':count dienÃ„â€¦|:count dienas|:count dienÃ…Â³',
    'hour_ago' => ':count valandÃ„â€¦|:count valandas|:count valandÃ…Â³',
    'minute_ago' => ':count minutÃ„â„¢|:count minutes|:count minuÃ„ÂiÃ…Â³',
    'second_ago' => ':count sekundÃ„â„¢|:count sekundes|:count sekundÃ…Â¾iÃ…Â³',

    'year_from_now' => ':count metai|:count metai|:count metÃ…Â³',
    'month_from_now' => ':count mÃ„â€”nuo|:count mÃ„â€”nesiai|:count mÃ„â€”nesiÃ…Â³',
    'week_from_now' => ':count savaitÃ„â€”|:count savaitÃ„â€”s|:count savaiÃ„ÂiÃ…Â³',
    'day_from_now' => ':count diena|:count dienos|:count dienÃ…Â³',
    'hour_from_now' => ':count valanda|:count valandos|:count valandÃ…Â³',
    'minute_from_now' => ':count minutÃ„â€”|:count minutÃ„â€”s|:count minuÃ„ÂiÃ…Â³',
    'second_from_now' => ':count sekundÃ„â€”|:count sekundÃ„â€”s|:count sekundÃ…Â¾iÃ…Â³',

    'year_after' => ':count metai|:count metai|:count metÃ…Â³',
    'month_after' => ':count mÃ„â€”nuo|:count mÃ„â€”nesiai|:count mÃ„â€”nesiÃ…Â³',
    'week_after' => ':count savaitÃ„â€”|:count savaitÃ„â€”s|:count savaiÃ„ÂiÃ…Â³',
    'day_after' => ':count diena|:count dienos|:count dienÃ…Â³',
    'hour_after' => ':count valanda|:count valandos|:count valandÃ…Â³',
    'minute_after' => ':count minutÃ„â€”|:count minutÃ„â€”s|:count minuÃ„ÂiÃ…Â³',
    'second_after' => ':count sekundÃ„â€”|:count sekundÃ„â€”s|:count sekundÃ…Â¾iÃ…Â³',

    'year_before' => ':count metÃ…Â³',
    'month_before' => ':count mÃ„â€”nesio|:count mÃ„â€”nesiÃ…Â³|:count mÃ„â€”nesiÃ…Â³',
    'week_before' => ':count savaitÃ„â€”s|:count savaiÃ„ÂiÃ…Â³|:count savaiÃ„ÂiÃ…Â³',
    'day_before' => ':count dienos|:count dienÃ…Â³|:count dienÃ…Â³',
    'hour_before' => ':count valandos|:count valandÃ…Â³|:count valandÃ…Â³',
    'minute_before' => ':count minutÃ„â€”s|:count minuÃ„ÂiÃ…Â³|:count minuÃ„ÂiÃ…Â³',
    'second_before' => ':count sekundÃ„â€”s|:count sekundÃ…Â¾iÃ…Â³|:count sekundÃ…Â¾iÃ…Â³',

    'ago' => 'prieÃ…Â¡ :time',
    'from_now' => ':time nuo dabar',
    'after' => 'po :time',
    'before' => 'uÃ…Â¾ :time',

    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,

    'diff_now' => 'kÃ„â€¦ tik',
    'diff_today' => 'Ã…Â iandien',
    'diff_yesterday' => 'vakar',
    'diff_yesterday_regexp' => 'Vakar',
    'diff_tomorrow' => 'rytoj',
    'diff_tomorrow_regexp' => 'Rytoj',
    'diff_before_yesterday' => 'uÃ…Â¾vakar',
    'diff_after_tomorrow' => 'poryt',

    'period_recurrences' => 'kartÃ„â€¦|:count kartÃ…Â³',
    'period_interval' => 'kiekvienÃ„â€¦ :interval',
    'period_start_date' => 'nuo :date',
    'period_end_date' => 'iki :date',

    'months' => ['sausio', 'vasario', 'kovo', 'balandÃ…Â¾io', 'geguÃ…Â¾Ã„â€”s', 'birÃ…Â¾elio', 'liepos', 'rugpjÃ…Â«Ã„Âio', 'rugsÃ„â€”jo', 'spalio', 'lapkriÃ„Âio', 'gruodÃ…Â¾io'],
    'months_standalone' => ['sausis', 'vasaris', 'kovas', 'balandis', 'geguÃ…Â¾Ã„â€”', 'birÃ…Â¾elis', 'liepa', 'rugpjÃ…Â«tis', 'rugsÃ„â€”jis', 'spalis', 'lapkritis', 'gruodis'],
    'months_regexp' => '/(L{2,4}|D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|MMMM?(\[[^\[\]]*\]|\s)+D[oD]?)/',
    'months_short' => ['sau', 'vas', 'kov', 'bal', 'geg', 'bir', 'lie', 'rgp', 'rgs', 'spa', 'lap', 'gru'],
    'weekdays' => ['sekmadienÃ„Â¯', 'pirmadienÃ„Â¯', 'antradienÃ„Â¯', 'treÃ„ÂiadienÃ„Â¯', 'ketvirtadienÃ„Â¯', 'penktadienÃ„Â¯', 'Ã…Â¡eÃ…Â¡tadienÃ„Â¯'],
    'weekdays_standalone' => ['sekmadienis', 'pirmadienis', 'antradienis', 'treÃ„Âiadienis', 'ketvirtadienis', 'penktadienis', 'Ã…Â¡eÃ…Â¡tadienis'],
    'weekdays_short' => ['sek', 'pir', 'ant', 'tre', 'ket', 'pen', 'Ã…Â¡eÃ…Â¡'],
    'weekdays_min' => ['se', 'pi', 'an', 'tr', 'ke', 'pe', 'Ã…Â¡e'],
    'list' => [', ', ' ir '],
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'YYYY-MM-DD',
        'LL' => 'MMMM DD, YYYY',
        'LLL' => 'DD MMM HH:mm',
        'LLLL' => 'MMMM DD, YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã…Â iandien] LT',
        'nextDay' => '[Rytoj] LT',
        'nextWeek' => 'dddd LT',
        'lastDay' => '[Vakar] LT',
        'lastWeek' => '[PaskutinÃ„Â¯] dddd LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        return match ($number) {
            0 => '0-is',
            3 => '3-ias',
            default => "$number-as",
        };
    },
    'meridiem' => ['prieÃ…Â¡piet', 'popiet'],
];
