<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Takuya Sawada
 * - Atsushi Tanaka
 * - FranÃƒÂ§ois B
 * - Jason Katz-Brown
 * - Serhan ApaydÃ„Â±n
 * - XueWei
 * - JD Isaacks
 * - toyama satoshi
 * - atakigawa
 */

use Carbon\CarbonInterface;

return [
    'year' => ':countÃ¥Â¹Â´',
    'y' => ':countÃ¥Â¹Â´',
    'month' => ':countÃ£Æ’Â¶Ã¦Å“Ë†',
    'm' => ':countÃ£Æ’Â¶Ã¦Å“Ë†',
    'week' => ':countÃ©â‚¬Â±Ã©â€“â€œ',
    'w' => ':countÃ©â‚¬Â±Ã©â€“â€œ',
    'day' => ':countÃ¦â€”Â¥',
    'd' => ':countÃ¦â€”Â¥',
    'hour' => ':countÃ¦â„¢â€šÃ©â€“â€œ',
    'h' => ':countÃ¦â„¢â€šÃ©â€“â€œ',
    'minute' => ':countÃ¥Ë†â€ ',
    'min' => ':countÃ¥Ë†â€ ',
    'second' => ':countÃ§Â§â€™',
    'a_second' => '{1}Ã¦â€¢Â°Ã§Â§â€™|[-Inf,Inf]:countÃ§Â§â€™',
    's' => ':countÃ§Â§â€™',
    'ago' => ':timeÃ¥â€°Â',
    'from_now' => ':timeÃ¥Â¾Å’',
    'after' => ':timeÃ¥Â¾Å’',
    'before' => ':timeÃ¥â€°Â',
    'diff_now' => 'Ã¤Â»Å ',
    'diff_today' => 'Ã¤Â»Å Ã¦â€”Â¥',
    'diff_yesterday' => 'Ã¦ËœÂ¨Ã¦â€”Â¥',
    'diff_tomorrow' => 'Ã¦ËœÅ½Ã¦â€”Â¥',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'YYYY/MM/DD',
        'LL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥',
        'LLL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥ HH:mm',
        'LLLL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥ dddd HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã¤Â»Å Ã¦â€”Â¥] LT',
        'nextDay' => '[Ã¦ËœÅ½Ã¦â€”Â¥] LT',
        'nextWeek' => static function (CarbonInterface $current, \Carbon\CarbonInterface $other) {
            if ($other->week !== $current->week) {
                return '[Ã¦ÂÂ¥Ã©â‚¬Â±]dddd LT';
            }

            return 'dddd LT';
        },
        'lastDay' => '[Ã¦ËœÂ¨Ã¦â€”Â¥] LT',
        'lastWeek' => static function (CarbonInterface $current, \Carbon\CarbonInterface $other) {
            if ($other->week !== $current->week) {
                return '[Ã¥â€¦Ë†Ã©â‚¬Â±]dddd LT';
            }

            return 'dddd LT';
        },
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number, $period) {
        return match ($period) {
            'd', 'D', 'DDD' => $number.'Ã¦â€”Â¥',
            default => $number,
        };
    },
    'meridiem' => ['Ã¥ÂË†Ã¥â€°Â', 'Ã¥ÂË†Ã¥Â¾Å’'],
    'months' => ['1Ã¦Å“Ë†', '2Ã¦Å“Ë†', '3Ã¦Å“Ë†', '4Ã¦Å“Ë†', '5Ã¦Å“Ë†', '6Ã¦Å“Ë†', '7Ã¦Å“Ë†', '8Ã¦Å“Ë†', '9Ã¦Å“Ë†', '10Ã¦Å“Ë†', '11Ã¦Å“Ë†', '12Ã¦Å“Ë†'],
    'months_short' => ['1Ã¦Å“Ë†', '2Ã¦Å“Ë†', '3Ã¦Å“Ë†', '4Ã¦Å“Ë†', '5Ã¦Å“Ë†', '6Ã¦Å“Ë†', '7Ã¦Å“Ë†', '8Ã¦Å“Ë†', '9Ã¦Å“Ë†', '10Ã¦Å“Ë†', '11Ã¦Å“Ë†', '12Ã¦Å“Ë†'],
    'weekdays' => ['Ã¦â€”Â¥Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã¦Å“Ë†Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã§ÂÂ«Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã¦Â°Â´Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã¦Å“Â¨Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã©â€¡â€˜Ã¦â€ºÅ“Ã¦â€”Â¥', 'Ã¥Å“Å¸Ã¦â€ºÅ“Ã¦â€”Â¥'],
    'weekdays_short' => ['Ã¦â€”Â¥', 'Ã¦Å“Ë†', 'Ã§ÂÂ«', 'Ã¦Â°Â´', 'Ã¦Å“Â¨', 'Ã©â€¡â€˜', 'Ã¥Å“Å¸'],
    'weekdays_min' => ['Ã¦â€”Â¥', 'Ã¦Å“Ë†', 'Ã§ÂÂ«', 'Ã¦Â°Â´', 'Ã¦Å“Â¨', 'Ã©â€¡â€˜', 'Ã¥Å“Å¸'],
    'list' => 'Ã£â‚¬Â',
    'alt_numbers' => ['Ã£â‚¬â€¡', 'Ã¤Â¸â‚¬', 'Ã¤ÂºÅ’', 'Ã¤Â¸â€°', 'Ã¥â€ºâ€º', 'Ã¤Âºâ€', 'Ã¥â€¦Â­', 'Ã¤Â¸Æ’', 'Ã¥â€¦Â«', 'Ã¤Â¹Â', 'Ã¥ÂÂ', 'Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¥ÂÂÃ¤Â¸â€°', 'Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¥ÂÂÃ¤Âºâ€', 'Ã¥ÂÂÃ¥â€¦Â­', 'Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¥ÂÂÃ¥â€¦Â«', 'Ã¥ÂÂÃ¤Â¹Â', 'Ã¤ÂºÅ’Ã¥ÂÂ', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤Â¸â€°', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤Âºâ€', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¥â€¦Â­', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¥â€¦Â«', 'Ã¤ÂºÅ’Ã¥ÂÂÃ¤Â¹Â', 'Ã¤Â¸â€°Ã¥ÂÂ', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤Â¸â€°', 'Ã¤Â¸â€°Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤Âºâ€', 'Ã¤Â¸â€°Ã¥ÂÂÃ¥â€¦Â­', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¤Â¸â€°Ã¥ÂÂÃ¥â€¦Â«', 'Ã¤Â¸â€°Ã¥ÂÂÃ¤Â¹Â', 'Ã¥â€ºâ€ºÃ¥ÂÂ', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤Â¸â‚¬', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤ÂºÅ’', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤Â¸â€°', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¥â€ºâ€º', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤Âºâ€', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¥â€¦Â­', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤Â¸Æ’', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¥â€¦Â«', 'Ã¥â€ºâ€ºÃ¥ÂÂÃ¤Â¹Â', 'Ã¤Âºâ€Ã¥ÂÂ', 'Ã¤Âºâ€Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¤Âºâ€Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¤Âºâ€Ã¥ÂÂÃ¤Â¸â€°', 'Ã¤Âºâ€Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¤Âºâ€Ã¥ÂÂÃ¤Âºâ€', 'Ã¤Âºâ€Ã¥ÂÂÃ¥â€¦Â­', 'Ã¤Âºâ€Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¤Âºâ€Ã¥ÂÂÃ¥â€¦Â«', 'Ã¤Âºâ€Ã¥ÂÂÃ¤Â¹Â', 'Ã¥â€¦Â­Ã¥ÂÂ', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤Â¸â€°', 'Ã¥â€¦Â­Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤Âºâ€', 'Ã¥â€¦Â­Ã¥ÂÂÃ¥â€¦Â­', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¥â€¦Â­Ã¥ÂÂÃ¥â€¦Â«', 'Ã¥â€¦Â­Ã¥ÂÂÃ¤Â¹Â', 'Ã¤Â¸Æ’Ã¥ÂÂ', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤Â¸â€°', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤Âºâ€', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¥â€¦Â­', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¥â€¦Â«', 'Ã¤Â¸Æ’Ã¥ÂÂÃ¤Â¹Â', 'Ã¥â€¦Â«Ã¥ÂÂ', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤Â¸â‚¬', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤ÂºÅ’', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤Â¸â€°', 'Ã¥â€¦Â«Ã¥ÂÂÃ¥â€ºâ€º', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤Âºâ€', 'Ã¥â€¦Â«Ã¥ÂÂÃ¥â€¦Â­', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤Â¸Æ’', 'Ã¥â€¦Â«Ã¥ÂÂÃ¥â€¦Â«', 'Ã¥â€¦Â«Ã¥ÂÂÃ¤Â¹Â', 'Ã¤Â¹ÂÃ¥ÂÂ', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤Â¸â‚¬', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤ÂºÅ’', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤Â¸â€°', 'Ã¤Â¹ÂÃ¥ÂÂÃ¥â€ºâ€º', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤Âºâ€', 'Ã¤Â¹ÂÃ¥ÂÂÃ¥â€¦Â­', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤Â¸Æ’', 'Ã¤Â¹ÂÃ¥ÂÂÃ¥â€¦Â«', 'Ã¤Â¹ÂÃ¥ÂÂÃ¤Â¹Â'],
    'alt_numbers_pow' => [
        10000 => 'Ã¤Â¸â€¡',
        1000 => 'Ã¥ÂÆ’',
        100 => 'Ã§â„¢Â¾',
    ],
];
