<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Josh Soref
 * - FranÃƒÂ§ois B
 * - Tim Fish
 * - shaishavgandhi05
 * - Serhan ApaydÃ„Â±n
 * - JD Isaacks
 * - tomhorvat
 * - Josh Soref
 * - FranÃƒÂ§ois B
 * - shaishavgandhi05
 * - Serhan ApaydÃ„Â±n
 * - JD Isaacks
 * - tomhorvat
 * - Stjepan Majdak
 * - Vanja Retkovac (vr00)
 */

use Carbon\CarbonInterface;

return [
    'year' => ':count godinu|:count godine|:count godina',
    'y' => ':count god.|:count god.|:count god.',
    'month' => ':count mjesec|:count mjeseca|:count mjeseci',
    'm' => ':count mj.|:count mj.|:count mj.',
    'week' => ':count tjedan|:count tjedna|:count tjedana',
    'w' => ':count tj.|:count tj.|:count tj.',
    'day' => ':count dan|:count dana|:count dana',
    'd' => ':count d.|:count d.|:count d.',
    'hour' => ':count sat|:count sata|:count sati',
    'h' => ':count sat|:count sata|:count sati',
    'minute' => ':count minutu|:count minute|:count minuta',
    'min' => ':count min.|:count min.|:count min.',
    'second' => ':count sekundu|:count sekunde|:count sekundi',
    'a_second' => 'nekoliko sekundi|:count sekunde|:count sekundi',
    's' => ':count sek.|:count sek.|:count sek.',
    'ago' => 'prije :time',
    'from_now' => 'za :time',
    'after' => ':time poslije',
    'before' => ':time prije',
    'diff_now' => 'sad',
    'diff_today' => 'danas',
    'diff_today_regexp' => 'danas(?:\\s+u)?',
    'diff_yesterday' => 'juÃ„Âer',
    'diff_yesterday_regexp' => 'juÃ„Âer(?:\\s+u)?',
    'diff_tomorrow' => 'sutra',
    'diff_tomorrow_regexp' => 'sutra(?:\\s+u)?',
    'diff_before_yesterday' => 'prekjuÃ„Âer',
    'diff_after_tomorrow' => 'prekosutra',
    'formats' => [
        'LT' => 'H:mm',
        'LTS' => 'H:mm:ss',
        'L' => 'D. M. YYYY.',
        'LL' => 'D. MMMM YYYY.',
        'LLL' => 'D. MMMM YYYY. H:mm',
        'LLLL' => 'dddd, D. MMMM YYYY. H:mm',
    ],
    'calendar' => [
        'sameDay' => '[danas u] LT',
        'nextDay' => '[sutra u] LT',
        'nextWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0 => '[u] [nedjelju] [u] LT',
            3 => '[u] [srijedu] [u] LT',
            6 => '[u] [subotu] [u] LT',
            default => '[u] dddd [u] LT',
        },
        'lastDay' => '[juÃ„Âer u] LT',
        'lastWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0, 3 => '[proÃ…Â¡lu] dddd [u] LT',
            6 => '[proÃ…Â¡le] [subote] [u] LT',
            default => '[proÃ…Â¡li] dddd [u] LT',
        },
        'sameElse' => 'L',
    ],
    'ordinal' => ':number.',
    'months' => ['sijeÃ„Ânja', 'veljaÃ„Âe', 'oÃ…Â¾ujka', 'travnja', 'svibnja', 'lipnja', 'srpnja', 'kolovoza', 'rujna', 'listopada', 'studenoga', 'prosinca'],
    'months_standalone' => ['sijeÃ„Âanj', 'veljaÃ„Âa', 'oÃ…Â¾ujak', 'travanj', 'svibanj', 'lipanj', 'srpanj', 'kolovoz', 'rujan', 'listopad', 'studeni', 'prosinac'],
    'months_short' => ['sij.', 'velj.', 'oÃ…Â¾u.', 'tra.', 'svi.', 'lip.', 'srp.', 'kol.', 'ruj.', 'lis.', 'stu.', 'pro.'],
    'months_regexp' => '/(D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['nedjelju', 'ponedjeljak', 'utorak', 'srijedu', 'Ã„Âetvrtak', 'petak', 'subotu'],
    'weekdays_standalone' => ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda', 'Ã„Âetvrtak', 'petak', 'subota'],
    'weekdays_short' => ['ned.', 'pon.', 'uto.', 'sri.', 'Ã„Âet.', 'pet.', 'sub.'],
    'weekdays_min' => ['ne', 'po', 'ut', 'sr', 'Ã„Âe', 'pe', 'su'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' i '],
];
