<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - FranÃƒÂ§ois B
 * - Jon Ashdown
 */
return [
    'year' => ':count bliadhna',
    'a_year' => '{1}bliadhna|:count bliadhna',
    'y' => ':count b.',
    'month' => ':count mÃƒÂ¬osan',
    'a_month' => '{1}mÃƒÂ¬os|:count mÃƒÂ¬osan',
    'm' => ':count ms.',
    'week' => ':count seachdainean',
    'a_week' => '{1}seachdain|:count seachdainean',
    'w' => ':count s.',
    'day' => ':count latha',
    'a_day' => '{1}latha|:count latha',
    'd' => ':count l.',
    'hour' => ':count uairean',
    'a_hour' => '{1}uair|:count uairean',
    'h' => ':count u.',
    'minute' => ':count mionaidean',
    'a_minute' => '{1}mionaid|:count mionaidean',
    'min' => ':count md.',
    'second' => ':count diogan',
    'a_second' => '{1}beagan diogan|:count diogan',
    's' => ':count d.',
    'ago' => 'bho chionn :time',
    'from_now' => 'ann an :time',
    'diff_yesterday' => 'An-dÃƒÂ¨',
    'diff_yesterday_regexp' => 'An-dÃƒÂ¨(?:\\s+aig)?',
    'diff_today' => 'An-diugh',
    'diff_today_regexp' => 'An-diugh(?:\\s+aig)?',
    'diff_tomorrow' => 'A-mÃƒÂ ireach',
    'diff_tomorrow_regexp' => 'A-mÃƒÂ ireach(?:\\s+aig)?',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[An-diugh aig] LT',
        'nextDay' => '[A-mÃƒÂ ireach aig] LT',
        'nextWeek' => 'dddd [aig] LT',
        'lastDay' => '[An-dÃƒÂ¨ aig] LT',
        'lastWeek' => 'dddd [seo chaidh] [aig] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        return $number.($number === 1 ? 'd' : ($number % 10 === 2 ? 'na' : 'mh'));
    },
    'months' => ['Am Faoilleach', 'An Gearran', 'Am MÃƒÂ rt', 'An Giblean', 'An CÃƒÂ¨itean', 'An t-Ãƒâ€™gmhios', 'An t-Iuchar', 'An LÃƒÂ¹nastal', 'An t-Sultain', 'An DÃƒÂ mhair', 'An t-Samhain', 'An DÃƒÂ¹bhlachd'],
    'months_short' => ['Faoi', 'Gear', 'MÃƒÂ rt', 'Gibl', 'CÃƒÂ¨it', 'Ãƒâ€™gmh', 'Iuch', 'LÃƒÂ¹n', 'Sult', 'DÃƒÂ mh', 'Samh', 'DÃƒÂ¹bh'],
    'weekdays' => ['DidÃƒÂ²mhnaich', 'Diluain', 'DimÃƒÂ irt', 'Diciadain', 'Diardaoin', 'Dihaoine', 'Disathairne'],
    'weekdays_short' => ['Did', 'Dil', 'Dim', 'Dic', 'Dia', 'Dih', 'Dis'],
    'weekdays_min' => ['DÃƒÂ²', 'Lu', 'MÃƒÂ ', 'Ci', 'Ar', 'Ha', 'Sa'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' agus '],
    'meridiem' => ['m', 'f'],
];
