<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Philippe Vaucher
 * - Jakub Tesinsky
 * - Martin Suja
 * - Nikos Timiopulos
 * - Bohuslav BlÃƒÂ­n
 * - Tsutomu Kuroda
 * - tjku
 * - Lukas Svoboda
 * - Max Melentiev
 * - Juanito Fatas
 * - Akira Matsuda
 * - Christopher Dell
 * - VÃƒÂ¡clav PÃƒÂ¡vek
 * - CodeSkills
 * - Tlapi
 * - newman101
 * - Petr Kadlec
 * - tommaskraus
 * - Karel Sommer (calvera)
 */
$za = function ($time) {
    return 'za '.strtr($time, [
        'hodina' => 'hodinu',
        'minuta' => 'minutu',
        'sekunda' => 'sekundu',
    ]);
};

$pred = function ($time) {
    $time = strtr($time, [
        'hodina' => 'hodinou',
        'minuta' => 'minutou',
        'sekunda' => 'sekundou',
    ]);
    $time = preg_replace('/hodiny?(?!\w)/', 'hodinami', $time);
    $time = preg_replace('/minuty?(?!\w)/', 'minutami', $time);
    $time = preg_replace('/sekundy?(?!\w)/', 'sekundami', $time);

    return "pÃ…â„¢ed $time";
};

return [
    'year' => ':count rok|:count roky|:count let',
    'y' => ':count rok|:count roky|:count let',
    'a_year' => 'rok|:count roky|:count let',
    'month' => ':count mÃ„â€ºsÃƒÂ­c|:count mÃ„â€ºsÃƒÂ­ce|:count mÃ„â€ºsÃƒÂ­cÃ…Â¯',
    'm' => ':count mÃ„â€ºs.',
    'a_month' => 'mÃ„â€ºsÃƒÂ­c|:count mÃ„â€ºsÃƒÂ­ce|:count mÃ„â€ºsÃƒÂ­cÃ…Â¯',
    'week' => ':count tÃƒÂ½den|:count tÃƒÂ½dny|:count tÃƒÂ½dnÃ…Â¯',
    'w' => ':count tÃƒÂ½d.',
    'a_week' => 'tÃƒÂ½den|:count tÃƒÂ½dny|:count tÃƒÂ½dnÃ…Â¯',
    'day' => ':count den|:count dny|:count dnÃƒÂ­',
    'd' => ':count den|:count dny|:count dnÃƒÂ­',
    'a_day' => 'den|:count dny|:count dnÃƒÂ­',
    'hour' => ':count hodina|:count hodiny|:count hodin',
    'h' => ':count hod.',
    'a_hour' => 'hodina|:count hodiny|:count hodin',
    'minute' => ':count minuta|:count minuty|:count minut',
    'min' => ':count min.',
    'a_minute' => 'minuta|:count minuty|:count minut',
    'second' => ':count sekunda|:count sekundy|:count sekund',
    's' => ':count sek.',
    'a_second' => 'pÃƒÂ¡r sekund|:count sekundy|:count sekund',

    'month_ago' => ':count mÃ„â€ºsÃƒÂ­cem|:count mÃ„â€ºsÃƒÂ­ci|:count mÃ„â€ºsÃƒÂ­ci',
    'a_month_ago' => 'mÃ„â€ºsÃƒÂ­cem|:count mÃ„â€ºsÃƒÂ­ci|:count mÃ„â€ºsÃƒÂ­ci',
    'day_ago' => ':count dnem|:count dny|:count dny',
    'a_day_ago' => 'dnem|:count dny|:count dny',
    'week_ago' => ':count tÃƒÂ½dnem|:count tÃƒÂ½dny|:count tÃƒÂ½dny',
    'a_week_ago' => 'tÃƒÂ½dnem|:count tÃƒÂ½dny|:count tÃƒÂ½dny',
    'year_ago' => ':count rokem|:count roky|:count lety',
    'y_ago' => ':count rok.|:count rok.|:count let.',
    'a_year_ago' => 'rokem|:count roky|:count lety',

    'month_before' => ':count mÃ„â€ºsÃƒÂ­cem|:count mÃ„â€ºsÃƒÂ­ci|:count mÃ„â€ºsÃƒÂ­ci',
    'a_month_before' => 'mÃ„â€ºsÃƒÂ­cem|:count mÃ„â€ºsÃƒÂ­ci|:count mÃ„â€ºsÃƒÂ­ci',
    'day_before' => ':count dnem|:count dny|:count dny',
    'a_day_before' => 'dnem|:count dny|:count dny',
    'week_before' => ':count tÃƒÂ½dnem|:count tÃƒÂ½dny|:count tÃƒÂ½dny',
    'a_week_before' => 'tÃƒÂ½dnem|:count tÃƒÂ½dny|:count tÃƒÂ½dny',
    'year_before' => ':count rokem|:count roky|:count lety',
    'y_before' => ':count rok.|:count rok.|:count let.',
    'a_year_before' => 'rokem|:count roky|:count lety',

    'ago' => $pred,
    'from_now' => $za,
    'before' => $pred,
    'after' => $za,
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'months' => ['ledna', 'ÃƒÂºnora', 'bÃ…â„¢ezna', 'dubna', 'kvÃ„â€ºtna', 'Ã„Âervna', 'Ã„Âervence', 'srpna', 'zÃƒÂ¡Ã…â„¢ÃƒÂ­', 'Ã…â„¢ÃƒÂ­jna', 'listopadu', 'prosince'],
    'months_standalone' => ['leden', 'ÃƒÂºnor', 'bÃ…â„¢ezen', 'duben', 'kvÃ„â€ºten', 'Ã„Âerven', 'Ã„Âervenec', 'srpen', 'zÃƒÂ¡Ã…â„¢ÃƒÂ­', 'Ã…â„¢ÃƒÂ­jen', 'listopad', 'prosinec'],
    'months_short' => ['led', 'ÃƒÂºno', 'bÃ…â„¢e', 'dub', 'kvÃ„â€º', 'Ã„Âvn', 'Ã„Âvc', 'srp', 'zÃƒÂ¡Ã…â„¢', 'Ã…â„¢ÃƒÂ­j', 'lis', 'pro'],
    'months_regexp' => '/(DD?o?\.?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['nedÃ„â€ºle', 'pondÃ„â€ºlÃƒÂ­', 'ÃƒÂºterÃƒÂ½', 'stÃ…â„¢eda', 'Ã„Âtvrtek', 'pÃƒÂ¡tek', 'sobota'],
    'weekdays_short' => ['ned', 'pon', 'ÃƒÂºte', 'stÃ…â„¢', 'Ã„Âtv', 'pÃƒÂ¡t', 'sob'],
    'weekdays_min' => ['ne', 'po', 'ÃƒÂºt', 'st', 'Ã„Ât', 'pÃƒÂ¡', 'so'],
    'list' => [', ', ' a '],
    'diff_now' => 'nynÃƒÂ­',
    'diff_yesterday' => 'vÃ„Âera',
    'diff_tomorrow' => 'zÃƒÂ­tra',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD. MM. YYYY',
        'LL' => 'D. MMMM YYYY',
        'LLL' => 'D. MMMM YYYY HH:mm',
        'LLLL' => 'dddd D. MMMM YYYY HH:mm',
    ],
    'meridiem' => ['dopoledne', 'odpoledne'],
];
