<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Carbon\CarbonInterface;
use Symfony\Component\Translation\PluralizationRules;

// @codeCoverageIgnoreStart
if (class_exists(PluralizationRules::class)) {
    PluralizationRules::set(static function ($number) {
        return (($number % 10 == 1) && ($number % 100 != 11)) ? 0 : ((($number % 10 >= 2) && ($number % 10 <= 4) && (($number % 100 < 10) || ($number % 100 >= 20))) ? 1 : 2);
    }, 'be');
}
// @codeCoverageIgnoreEnd

/*
 * Authors:
 * - Josh Soref
 * - SobakaSlava
 * - FranÃƒÂ§ois B
 * - Serhan ApaydÃ„Â±n
 * - JD Isaacks
 * - AbadonnaAbbys
 * - Siomkin Alexander
 */
return [
    'year' => ':count ÃÂ³ÃÂ¾ÃÂ´|:count ÃÂ³ÃÂ°ÃÂ´Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ¾Ã‘Å¾',
    'a_year' => '{1}ÃÂ³ÃÂ¾ÃÂ´|:count ÃÂ³ÃÂ¾ÃÂ´|:count ÃÂ³ÃÂ°ÃÂ´Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ¾Ã‘Å¾',
    'y' => ':count ÃÂ³ÃÂ¾ÃÂ´|:count ÃÂ³ÃÂ°ÃÂ´Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ¾Ã‘Å¾',
    'month' => ':count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ |:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ Ã‘â€¹|:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂ°Ã‘Å¾',
    'a_month' => '{1}ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ |:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ |:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ Ã‘â€¹|:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂ°Ã‘Å¾',
    'm' => ':count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ |:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ Ã‘â€¹|:count ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂ°Ã‘Å¾',
    'week' => ':count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘â€“|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘ÂÃ‘Å¾',
    'a_week' => '{1}Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘â€“|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘ÂÃ‘Å¾',
    'w' => ':count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘â€“|:count Ã‘â€šÃ‘â€¹ÃÂ´ÃÂ½Ã‘ÂÃ‘Å¾',
    'day' => ':count ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂ½Ã‘â€“|:count ÃÂ´ÃÂ·Ã‘â€˜ÃÂ½',
    'a_day' => '{1}ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’|:count ÃÂ´ÃÂ½Ã‘â€“|:count ÃÂ´ÃÂ·Ã‘â€˜ÃÂ½',
    'd' => ':count ÃÂ´ÃÂ½',
    'hour' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'a_hour' => '{1}ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'h' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'minute' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'a_minute' => '{1}Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½ÃÂ°|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'min' => ':count Ã‘â€¦ÃÂ²',
    'second' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ°|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second' => '{1}ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ°|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's' => ':count Ã‘ÂÃÂµÃÂº',

    'hour_ago' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'a_hour_ago' => '{1}ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'h_ago' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'minute_ago' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'a_minute_ago' => '{1}Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'min_ago' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'second_ago' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_ago' => '{1}ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's_ago' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_from_now' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'a_hour_from_now' => '{1}ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'h_from_now' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'minute_from_now' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'a_minute_from_now' => '{1}Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'min_from_now' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'second_from_now' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_from_now' => '{1}ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's_from_now' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_after' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'a_hour_after' => '{1}ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'h_after' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'minute_after' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'a_minute_after' => '{1}Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'min_after' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'second_after' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_after' => '{1}ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's_after' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'hour_before' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'a_hour_before' => '{1}ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'h_before' => ':count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹|:count ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½',
    'minute_before' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'a_minute_before' => '{1}Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'min_before' => ':count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹|:count Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½',
    'second_before' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    'a_second_before' => '{1}ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',
    's_before' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘Æ’|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´Ã‘â€¹|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´',

    'ago' => ':time Ã‘â€šÃÂ°ÃÂ¼Ã‘Æ’',
    'from_now' => 'ÃÂ¿Ã‘â‚¬ÃÂ°ÃÂ· :time',
    'after' => ':time ÃÂ¿ÃÂ°Ã‘ÂÃÂ»Ã‘Â',
    'before' => ':time ÃÂ´ÃÂ°',
    'diff_now' => 'Ã‘â€ Ã‘ÂÃÂ¿ÃÂµÃ‘â‚¬',
    'diff_today' => 'ÃÂ¡Ã‘â€˜ÃÂ½ÃÂ½Ã‘Â',
    'diff_today_regexp' => 'ÃÂ¡Ã‘â€˜ÃÂ½ÃÂ½Ã‘Â(?:\\s+Ã‘Å¾)?',
    'diff_yesterday' => 'Ã‘Æ’Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°',
    'diff_yesterday_regexp' => 'ÃÂ£Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°(?:\\s+Ã‘Å¾)?',
    'diff_tomorrow' => 'ÃÂ·ÃÂ°Ã‘Å¾Ã‘â€šÃ‘â‚¬ÃÂ°',
    'diff_tomorrow_regexp' => 'Ãâ€”ÃÂ°Ã‘Å¾Ã‘â€šÃ‘â‚¬ÃÂ°(?:\\s+Ã‘Å¾)?',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY ÃÂ³.',
        'LLL' => 'D MMMM YYYY ÃÂ³., HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY ÃÂ³., HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[ÃÂ¡Ã‘â€˜ÃÂ½ÃÂ½Ã‘Â Ã‘Å¾] LT',
        'nextDay' => '[Ãâ€”ÃÂ°Ã‘Å¾Ã‘â€šÃ‘â‚¬ÃÂ° Ã‘Å¾] LT',
        'nextWeek' => '[ÃÂ£] dddd [Ã‘Å¾] LT',
        'lastDay' => '[ÃÂ£Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ° Ã‘Å¾] LT',
        'lastWeek' => static fn (CarbonInterface $current) => match ($current->dayOfWeek) {
            1, 2, 4 => '[ÃÂ£ ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘â€¹] dddd [Ã‘Å¾] LT',
            default => '[ÃÂ£ ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘Æ’Ã‘Å½] dddd [Ã‘Å¾] LT',
        },
        'sameElse' => 'L',
    ],
    'ordinal' => static fn ($number, $period) => match ($period) {
        'M', 'd', 'DDD', 'w', 'W' => ($number % 10 === 2 || $number % 10 === 3) &&
                ($number % 100 !== 12 && $number % 100 !== 13) ? $number.'-Ã‘â€“' : $number.'-Ã‘â€¹',
        'D' => $number.'-ÃÂ³ÃÂ°',
        default => $number,
    },
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€¹';
        }

        if ($hour < 12) {
            return 'Ã‘â‚¬ÃÂ°ÃÂ½Ã‘â€“Ã‘â€ Ã‘â€¹';
        }

        if ($hour < 17) {
            return 'ÃÂ´ÃÂ½Ã‘Â';
        }

        return 'ÃÂ²ÃÂµÃ‘â€¡ÃÂ°Ã‘â‚¬ÃÂ°';
    },
    'months' => ['Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Â', 'ÃÂ»Ã‘Å½Ã‘â€šÃÂ°ÃÂ³ÃÂ°', 'Ã‘ÂÃÂ°ÃÂºÃÂ°ÃÂ²Ã‘â€“ÃÂºÃÂ°', 'ÃÂºÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ°ÃÂ²Ã‘â€“ÃÂºÃÂ°', 'Ã‘â€šÃ‘â‚¬ÃÂ°Ã‘Å¾ÃÂ½Ã‘Â', 'Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Â', 'ÃÂ»Ã‘â€“ÃÂ¿ÃÂµÃÂ½Ã‘Â', 'ÃÂ¶ÃÂ½Ã‘â€“Ã‘Å¾ÃÂ½Ã‘Â', 'ÃÂ²ÃÂµÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ½Ã‘Â', 'ÃÂºÃÂ°Ã‘ÂÃ‘â€šÃ‘â‚¬Ã‘â€¹Ã‘â€¡ÃÂ½Ã‘â€“ÃÂºÃÂ°', 'ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€šÃÂ°ÃÂ¿ÃÂ°ÃÂ´ÃÂ°', 'Ã‘ÂÃÂ½ÃÂµÃÂ¶ÃÂ½Ã‘Â'],
    'months_standalone' => ['Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’', 'ÃÂ»Ã‘Å½Ã‘â€šÃ‘â€¹', 'Ã‘ÂÃÂ°ÃÂºÃÂ°ÃÂ²Ã‘â€“ÃÂº', 'ÃÂºÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ°ÃÂ²Ã‘â€“ÃÂº', 'Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂµÃÂ½Ã‘Å’', 'Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Å’', 'ÃÂ»Ã‘â€“ÃÂ¿ÃÂµÃÂ½Ã‘Å’', 'ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²ÃÂµÃÂ½Ã‘Å’', 'ÃÂ²ÃÂµÃ‘â‚¬ÃÂ°Ã‘ÂÃÂµÃÂ½Ã‘Å’', 'ÃÂºÃÂ°Ã‘ÂÃ‘â€šÃ‘â‚¬Ã‘â€¹Ã‘â€¡ÃÂ½Ã‘â€“ÃÂº', 'ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€šÃÂ°ÃÂ¿ÃÂ°ÃÂ´', 'Ã‘ÂÃÂ½ÃÂµÃÂ¶ÃÂ°ÃÂ½Ã‘Å’'],
    'months_short' => ['Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´', 'ÃÂ»Ã‘Å½Ã‘â€š', 'Ã‘ÂÃÂ°ÃÂº', 'ÃÂºÃ‘â‚¬ÃÂ°Ã‘Â', 'Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²', 'Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²', 'ÃÂ»Ã‘â€“ÃÂ¿', 'ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²', 'ÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂºÃÂ°Ã‘ÂÃ‘â€š', 'ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€š', 'Ã‘ÂÃÂ½ÃÂµÃÂ¶'],
    'months_regexp' => '/(DD?o?\.?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»Ã‘Å½', 'ÃÂ¿ÃÂ°ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»ÃÂ°ÃÂº', 'ÃÂ°Ã‘Å¾Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂ°ÃÂ´Ã‘Æ’', 'Ã‘â€¡ÃÂ°Ã‘â€ ÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½Ã‘â€“Ã‘â€ Ã‘Æ’', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’'],
    'weekdays_standalone' => ['ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»Ã‘Â', 'ÃÂ¿ÃÂ°ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»ÃÂ°ÃÂº', 'ÃÂ°Ã‘Å¾Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº', 'Ã‘ÂÃÂµÃ‘â‚¬ÃÂ°ÃÂ´ÃÂ°', 'Ã‘â€¡ÃÂ°Ã‘â€ ÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½Ã‘â€“Ã‘â€ ÃÂ°', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°'],
    'weekdays_short' => ['ÃÂ½ÃÂ´', 'ÃÂ¿ÃÂ½', 'ÃÂ°Ã‘â€š', 'Ã‘ÂÃ‘â‚¬', 'Ã‘â€¡Ã‘â€ ', 'ÃÂ¿Ã‘â€š', 'Ã‘ÂÃÂ±'],
    'weekdays_min' => ['ÃÂ½ÃÂ´', 'ÃÂ¿ÃÂ½', 'ÃÂ°Ã‘â€š', 'Ã‘ÂÃ‘â‚¬', 'Ã‘â€¡Ã‘â€ ', 'ÃÂ¿Ã‘â€š', 'Ã‘ÂÃÂ±'],
    'weekdays_regexp' => '/\[ ?[ÃÂ£Ã‘Æ’Ã‘Å¾] ?(?:ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘Æ’Ã‘Å½|ÃÂ½ÃÂ°Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ¿ÃÂ½Ã‘Æ’Ã‘Å½)? ?\] ?dddd/',
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' Ã‘â€“ '],
    'months_short_standalone' => ['Ã‘ÂÃ‘â€šÃ‘Æ’', 'ÃÂ»Ã‘Å½Ã‘â€š', 'Ã‘ÂÃÂ°ÃÂº', 'ÃÂºÃ‘â‚¬ÃÂ°', 'ÃÂ¼ÃÂ°ÃÂ¹', 'Ã‘â€¡Ã‘ÂÃ‘â‚¬', 'ÃÂ»Ã‘â€“ÃÂ¿', 'ÃÂ¶ÃÂ½Ã‘â€“', 'ÃÂ²ÃÂµÃ‘â‚¬', 'ÃÂºÃÂ°Ã‘Â', 'ÃÂ»Ã‘â€“Ã‘Â', 'Ã‘ÂÃÂ½ÃÂµ'],
];
