<?php

namespace Laravel\Prompts\Themes\Default;

use Laravel\Prompts\Output\BufferedConsoleOutput;
use Laravel\Prompts\Table;
use Symfony\Component\Console\Helper\Table as SymfonyTable;
use Symfony\Component\Console\Helper\TableStyle;

class TableRenderer extends Renderer
{
    /**
     * Render the table.
     */
    public function __invoke(Table $table): string
    {
        $tableStyle = (new TableStyle)
            ->setHorizontalBorderChars('Ã¢â€â‚¬')
            ->setVerticalBorderChars('Ã¢â€â€š', 'Ã¢â€â€š')
            ->setCellHeaderFormat($this->dim('<fg=default>%s</>'))
            ->setCellRowFormat('<fg=default>%s</>');

        if (empty($table->headers)) {
            $tableStyle->setCrossingChars('Ã¢â€Â¼', '', '', '', 'Ã¢â€Â¤', 'Ã¢â€Ëœ</>', 'Ã¢â€Â´', 'Ã¢â€â€', 'Ã¢â€Å“', '<fg=gray>Ã¢â€Å’', 'Ã¢â€Â¬', 'Ã¢â€Â');
        } else {
            $tableStyle->setCrossingChars('Ã¢â€Â¼', '<fg=gray>Ã¢â€Å’', 'Ã¢â€Â¬', 'Ã¢â€Â', 'Ã¢â€Â¤', 'Ã¢â€Ëœ</>', 'Ã¢â€Â´', 'Ã¢â€â€', 'Ã¢â€Å“');
        }

        $buffered = new BufferedConsoleOutput;

        (new SymfonyTable($buffered))
            ->setHeaders($table->headers)
            ->setRows($table->rows)
            ->setStyle($tableStyle)
            ->render();

        foreach (explode(PHP_EOL, trim($buffered->content(), PHP_EOL)) as $line) {
            $this->line(' '.$line);
        }

        return $this;
    }
}
