<?php

namespace Laravel\Prompts\Themes\Default;

use Laravel\Prompts\Spinner;

class SpinnerRenderer extends Renderer
{
    /**
     * The frames of the spinner.
     *
     * @var array<string>
     */
    protected array $frames = ['Ã¢Â â€š', 'Ã¢Â â€™', 'Ã¢Â Â', 'Ã¢Â Â°', 'Ã¢Â Â ', 'Ã¢Â Â¤', 'Ã¢Â â€ž', 'Ã¢Â â€ '];

    /**
     * The frame to render when the spinner is static.
     */
    protected string $staticFrame = 'Ã¢Â Â¶';

    /**
     * The interval between frames.
     */
    protected int $interval = 75;

    /**
     * Render the spinner.
     */
    public function __invoke(Spinner $spinner): string
    {
        if ($spinner->static) {
            return $this->line(" {$this->cyan($this->staticFrame)} {$spinner->message}");
        }

        $spinner->interval = $this->interval;

        $frame = $this->frames[$spinner->count % count($this->frames)];

        return $this->line(" {$this->cyan($frame)} {$spinner->message}");
    }
}
