<?php

use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\TransactionLogController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Web\WalletController;
use Illuminate\Support\Facades\Route;

Route::get('/', fn () => view('welcome'));

Route::middleware(['auth', 'verified', 'account.active'])->group(function () {
    Route::get('/dashboard', [WalletController::class, 'dashboard'])->name('wallet.dashboard');
    Route::post('/wallet/send', [WalletController::class, 'send'])->name('wallet.send');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth', 'verified', 'role:super_admin|admin|support'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/transactions', [TransactionLogController::class, 'index'])->name('transactions.index');

    Route::get('/users', [UserManagementController::class, 'index'])->name('users.index');
    Route::patch('/users/{user}', [UserManagementController::class, 'update'])->name('users.update');

    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/smtp', [SettingsController::class, 'updateSmtp'])->name('settings.smtp');
    Route::post('/settings/features', [SettingsController::class, 'updateFeatures'])->name('settings.features');
    Route::post('/settings/branding', [SettingsController::class, 'updateBranding'])->name('settings.branding');
});

require __DIR__.'/auth.php';
