<?php

use App\Http\Controllers\Api\V1\ApiTokenController;
use App\Http\Controllers\Api\V1\MeController;
use App\Http\Controllers\Api\V1\PaymentLinkController;
use App\Http\Controllers\Api\V1\SettingsController;
use App\Http\Controllers\Api\V1\TransferController;
use Illuminate\Support\Facades\Route;

Route::prefix('v1')->middleware(['throttle:120,1', 'api.signature'])->group(function () {
    Route::get('/me/balance', [MeController::class, 'balance']);
    Route::get('/me/transactions', [MeController::class, 'transactions']);

    Route::post('/transfers', [TransferController::class, 'store'])->middleware('throttle:30,1');

    Route::post('/payment-links', [PaymentLinkController::class, 'store'])->middleware('throttle:30,1');
    Route::get('/payment-links/{code}', [PaymentLinkController::class, 'show']);
    Route::post('/payment-links/{code}/pay', [PaymentLinkController::class, 'pay'])->middleware('throttle:30,1');

    Route::post('/api-tokens/rotate', [ApiTokenController::class, 'rotate'])->middleware('throttle:10,1');
    Route::get('/settings/features', [SettingsController::class, 'features']);
});
