<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Wallet Dashboard</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="bg-white p-6 rounded-xl shadow">
                <p class="text-sm text-gray-500">Your Public ID</p>
                <p class="font-mono text-lg">{{ $user->public_id }}</p>
                <p class="mt-3 text-2xl font-bold">{{ number_format($wallet->available_balance / 100, 2) }} {{ $wallet->currency }}</p>
            </div>

            <div class="bg-white p-6 rounded-xl shadow">
                <h3 class="font-semibold mb-3">Send Money</h3>
                <form method="POST" action="{{ route('wallet.send') }}" class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    @csrf
                    <input name="receiver_public_id" placeholder="Receiver Public ID" class="rounded border-gray-300" required>
                    <input name="amount" type="number" min="1" placeholder="Amount (cents)" class="rounded border-gray-300" required>
                    <input name="idempotency_key" value="{{ (string) \\Illuminate\\Support\\Str::uuid() }}" class="rounded border-gray-300" required>
                    <input name="totp_code" placeholder="2FA code (if enabled)" class="rounded border-gray-300">
                    <input name="note" placeholder="Note" class="rounded border-gray-300 md:col-span-2">
                    <label class="md:col-span-2 text-sm"><input type="checkbox" name="confirm" value="1" required> Confirm this transfer</label>
                    <button class="bg-sky-600 hover:bg-sky-700 text-white rounded px-4 py-2 md:col-span-2">Send</button>
                </form>
                @if ($errors->any())
                    <div class="mt-3 text-red-600 text-sm">{{ $errors->first() }}</div>
                @endif
                @if (session('status'))
                    <div class="mt-3 text-green-700 text-sm">{{ session('status') }}</div>
                @endif
            </div>

            <div class="bg-white p-6 rounded-xl shadow">
                <h3 class="font-semibold mb-3">Latest Transactions</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead>
                            <tr class="text-left border-b">
                                <th class="py-2">Date</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Balance After</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($transactions as $t)
                                <tr class="border-b">
                                    <td class="py-2">{{ $t->created_at }}</td>
                                    <td>{{ $t->direction }}</td>
                                    <td>{{ $t->amount }}</td>
                                    <td>{{ $t->balance_after }}</td>
                                    <td>{{ $t->reference_type }} #{{ $t->reference_id }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="5" class="py-3 text-gray-500">No transactions yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
