# Nano ID

<img src="https://ai.github.io/nanoid/logo.svg" align="right"
     alt="Nano ID logo by Anton Lovchikov" width="180" height="94">

**English** | [Ð ÑƒÑÑÐºÐ¸Ð¹](./README.ru.md) | [ç®€ä½“ä¸­æ–‡](./README.zh-CN.md) | [Bahasa Indonesia](./README.id-ID.md)

A tiny, secure, URL-friendly, uniqueÂ string IDÂ generator forÂ JavaScript.

> â€œAn amazing level of senseless perfectionism,
> which is simply impossible not to respect.â€

* **Small.** 130 bytes (minified and gzipped). NoÂ dependencies.
  [Size Limit] controls the size.
* **Fast.** It is 2 times faster than UUID.
* **Safe.** It uses hardware random generator. Can be used in clusters.
* **Short IDs.** It uses aÂ larger alphabet than UUID (`A-Za-z0-9_-`).
  So ID size was reduced fromÂ 36Â toÂ 21Â symbols.
* **Portable.** Nano ID was ported
  to [20 programming languages](#other-programming-languages).

```js
import { nanoid } from 'nanoid'
model.id = nanoid() //=> "V1StGXR8_Z5jdHi6B-myT"
```

Supports modern browsers, IE [with Babel], Node.js and React Native.

[online tool]: https://gitpod.io/#https://github.com/ai/nanoid/
[with Babel]:  https://developer.epages.com/blog/coding/how-to-transpile-node-modules-with-babel-and-webpack-in-a-monorepo/
[Size Limit]:  https://github.com/ai/size-limit

<a href="https://evilmartians.com/?utm_source=nanoid">
  <img src="https://evilmartians.com/badges/sponsored-by-evil-martians.svg"
       alt="Sponsored by Evil Martians" width="236" height="54">
</a>

## Docs
Read full docs **[here](https://github.com/ai/nanoid#readme)**.
