<?php

namespace Database\Seeders;

use App\Models\FeatureFlag;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        foreach (['super_admin', 'admin', 'support'] as $role) {
            Role::findOrCreate($role, 'web');
        }

        foreach (['wallet.transfer', 'business.payment_links', 'api.access'] as $featureKey) {
            FeatureFlag::query()->updateOrCreate(
                ['scope' => 'global', 'user_id' => null, 'feature_key' => $featureKey],
                ['is_enabled' => true]
            );
        }
    }
}
