﻿<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('ledger_entries', function (Blueprint $table) {
            $table->foreign('wallet_id')->references('id')->on('wallets')->cascadeOnDelete();
        });

        Schema::table('payment_link_payments', function (Blueprint $table) {
            $table->foreign('payment_link_id')->references('id')->on('payment_links')->cascadeOnDelete();
            $table->foreign('payer_user_id')->references('id')->on('users');
            $table->foreign('transfer_id')->references('id')->on('transfers')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('payment_link_payments', function (Blueprint $table) {
            $table->dropForeign(['payment_link_id']);
            $table->dropForeign(['payer_user_id']);
            $table->dropForeign(['transfer_id']);
        });

        Schema::table('ledger_entries', function (Blueprint $table) {
            $table->dropForeign(['wallet_id']);
        });
    }
};
