<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('api_nonces', function (Blueprint $table) {
            $table->id();
            $table->string('key_id', 48);
            $table->string('nonce', 96);
            $table->timestamp('request_ts');
            $table->timestamp('expires_at');
            $table->timestamps();

            $table->unique(['key_id', 'nonce']);
            $table->index('expires_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('api_nonces');
    }
};
