<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payment_link_payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_link_id');
            $table->uuid('payer_user_id');
            $table->bigInteger('amount');
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('completed');
            $table->unsignedBigInteger('transfer_id')->nullable();
            $table->timestamps();

            $table->index(['payment_link_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payment_link_payments');
    }
};
