<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payment_links', function (Blueprint $table) {
            $table->id();
            $table->uuid('merchant_user_id');
            $table->string('code', 32)->unique();
            $table->string('title', 120);
            $table->text('description')->nullable();
            $table->bigInteger('fixed_amount')->nullable();
            $table->boolean('allow_custom_amount')->default(false);
            $table->timestamp('expires_at')->nullable();
            $table->boolean('single_use')->default(true);
            $table->enum('status', ['active', 'paid', 'expired', 'disabled'])->default('active');
            $table->timestamps();

            $table->foreign('merchant_user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->index(['merchant_user_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payment_links');
    }
};
