<?php

namespace App\Support\Security;

use Illuminate\Support\Arr;

class TelegramVerifier
{
    public function verify(array $data, string $botToken, int $maxAgeSeconds = 300): bool
    {
        $hash = Arr::get($data, 'hash');
        if (! $hash) {
            return false;
        }

        $authDate = (int) Arr::get($data, 'auth_date', 0);
        if ($authDate <= 0 || now()->timestamp - $authDate > $maxAgeSeconds) {
            return false;
        }

        $checkData = $data;
        unset($checkData['hash']);
        ksort($checkData);

        $dataCheckString = collect($checkData)
            ->map(fn ($value, $key) => $key.'='.$value)
            ->implode("\n");

        $secretKey = hash('sha256', $botToken, true);
        $computed = hash_hmac('sha256', $dataCheckString, $secretKey);

        return hash_equals($computed, $hash);
    }
}
