<?php

namespace App\Support\Security;

use App\Models\User;
use Illuminate\Support\Str;

class PublicIdGenerator
{
    public function generateUserId(): string
    {
        do {
            $id = Str::lower(Str::random(10));
        } while (User::query()->where('public_id', $id)->exists());

        return $id;
    }

    public function generatePaymentCode(): string
    {
        return Str::lower(Str::random(20));
    }

    public function generateApiKeyId(): string
    {
        return 'wk_'.Str::lower(Str::random(24));
    }

    public function generateApiSecret(): string
    {
        return Str::random(64);
    }
}
