<?php

namespace App\Services;

use App\Models\SystemSetting;
use Illuminate\Support\Facades\Cache;

class SystemSettingsService
{
    public function get(string $key, ?string $default = null): ?string
    {
        return Cache::remember("setting:{$key}", 600, fn () => SystemSetting::getValue($key, $default));
    }

    public function set(string $key, ?string $value): void
    {
        SystemSetting::setValue($key, $value);
        Cache::forget("setting:{$key}");
    }
}
