<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserSecurity extends Model
{
    protected $primaryKey = 'user_id';

    public $incrementing = false;

    protected $keyType = 'string';

    protected $fillable = [
        'user_id',
        'totp_enabled',
        'totp_secret_enc',
        'last_login_at',
        'failed_attempts',
        'locked_until',
    ];

    protected function casts(): array
    {
        return [
            'totp_enabled' => 'boolean',
            'totp_secret_enc' => 'encrypted',
            'last_login_at' => 'datetime',
            'locked_until' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
