<?php

namespace App\Http\Requests\Wallet;

use Illuminate\Foundation\Http\FormRequest;

class StoreTransferRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'receiver_public_id' => ['required', 'string', 'max:16', 'exists:users,public_id'],
            'amount' => ['required', 'integer', 'min:1'],
            'note' => ['nullable', 'string', 'max:200'],
            'idempotency_key' => ['required', 'string', 'max:128'],
            'totp_code' => ['nullable', 'string', 'max:12'],
            'confirm' => ['required', 'accepted'],
        ];
    }
}
