<?php

namespace App\Domain\API;

use App\Models\ApiCredential;
use App\Models\User;
use App\Support\Security\PublicIdGenerator;

class ApiCredentialService
{
    public function __construct(private readonly PublicIdGenerator $generator)
    {
    }

    public function rotate(User $user): array
    {
        ApiCredential::query()->where('user_id', $user->id)->where('is_active', true)->update([
            'is_active' => false,
            'rotated_at' => now(),
        ]);

        $keyId = $this->generator->generateApiKeyId();
        $secret = $this->generator->generateApiSecret();

        ApiCredential::query()->create([
            'user_id' => $user->id,
            'key_id' => $keyId,
            'secret_enc' => $secret,
            'is_active' => true,
        ]);

        return [
            'key_id' => $keyId,
            'secret' => $secret,
        ];
    }
}
