# Secure Wallet Platform (Laravel 11)

Production-ready internal wallet system with:
- User-to-user transfers by short unique `public_id`.
- Business payment links (single-use, optional custom amount, expiry).
- Admin panel for users, transaction logs, and system settings.
- Signed REST API (`API key + HMAC + timestamp + nonce`).
- Email verification + Telegram official login callback.
- RBAC roles: `super_admin`, `admin`, `support`.

## Shared Hosting Installation (No Install Page Required)

1. Upload project files to hosting.
2. Ensure document root points to `public/`.
3. Ensure `storage/` and `bootstrap/cache/` are writable.
4. Configure `.env` DB credentials:
   - MySQL: `DB_CONNECTION=mysql`, host/port/database/username/password.
   - Supabase: `DB_CONNECTION=pgsql` and either regular DB vars or `DB_URL`.
5. Set bootstrap values in `.env`:
   - `BOOTSTRAP_SYSTEM_NAME`
   - `BOOTSTRAP_SYSTEM_COPYRIGHT`
   - `BOOTSTRAP_ADMIN_EMAIL`
   - `BOOTSTRAP_ADMIN_USERNAME`
   - `BOOTSTRAP_ADMIN_PASSWORD`
6. Run once:
   - `php artisan migrate --force`
   - `php artisan db:seed --force`

The seeder will create branding + first `super_admin` account automatically.

## Manual CLI Setup

1. `composer install`
2. Configure `.env`
3. `php artisan migrate --force`
4. `php artisan db:seed --force`
5. `npm install && npm run build`

## API Documentation
- Human-readable: `docs/REST_API.md`
- OpenAPI spec: `docs/openapi.yaml`

## Security Layers
- Row-level locking + DB transactions for financial writes.
- Idempotency keys on transfer/payment requests.
- TOTP support for sensitive actions.
- API replay protection with nonce/timestamp window.
- Global and per-user feature toggles.
- Transfer daily/monthly/velocity limits.
- Security headers middleware.
